using UnityEngine;
using UnityEngine.UI;

public class ButtonAnimation : MonoBehaviour
{
    private Animator animator;
    private bool isClicked = false;

    private void Start()
    {
        animator = GetComponent<Animator>();
        Button btn = GetComponent<Button>();
        btn.onClick.AddListener(TaskOnClick);
    }

    private void TaskOnClick()
    {
        if (isClicked) return;
        isClicked = true;
        animator.SetTrigger("Trigger");
        Invoke("ControlBool", 0.35f);
    }

    private void ControlBool()
    {
        isClicked = false;
    }
}