using UnityEngine;
using System.Collections;

public class CharacterControl : MonoBehaviour
{
    [SerializeField] private int scoreIncrease = 10;
    [SerializeField] private float destructTime = 0.5f;
    [SerializeField] private GameObject explosion;
    [SerializeField] private SpriteRenderer spriteRenderer;
    [SerializeField] Settings settings;
    private float controlSpeed;
    private float yPosition;
    private float scaleValue;
    private float rotationSpeed;
    private float shrinkingTime = 0.0001f;
    private float destructDuration = 0.0f;
    private int rotationOrientation;
    private bool destruct = false;
    private Vector3 position = Vector3.zero;
    private Vector3 finalScale = new Vector3(0.0005f, 0.0005f, 1);

    private void Start()
    {
        SetValues();
    }

    private void Update()
    {
        FallDown();
        Rotate();

        if(!destruct || !Globals.UseEffects)
            transform.localPosition = position;
        else
            Destruct();
    }

    private void SetValues()
    {
        scaleValue = Random.Range(settings.ScaleMin, settings.ScaleMax);
        controlSpeed = Random.Range(settings.SpeedMin, settings.SpeedMax);
        rotationOrientation = Random.Range(1, 3);

        if (rotationOrientation == 2) rotationOrientation = -1;

        rotationSpeed = Random.Range(settings.RotationSpeedMin, settings.RotationSpeedMax) * (controlSpeed / 7.5f) * rotationOrientation;
        transform.localScale = new Vector3(scaleValue, scaleValue, 1);

        spriteRenderer.sortingOrder = Globals.Counter;
        Globals.Counter++;
        if (Globals.Counter > 500) Globals.Counter = 1;
    }

    private void FallDown()
    {
        yPosition = transform.localPosition.y - controlSpeed * Time.deltaTime;
        position = new Vector3(transform.localPosition.x, yPosition, transform.localPosition.z);

        if (transform.localPosition.y < -10) Destroy(gameObject);
    }

    private void Destruct()
    {
        if (!destruct) return;
        float progress = Mathf.Clamp(destructDuration / destructTime, 0, 1);
        Vector3 shakePos = position + Random.insideUnitSphere * 0.1f;
        this.transform.localPosition = new Vector3(shakePos.x, shakePos.y, this.transform.localPosition.z);
        spriteRenderer.material.SetFloat("_FullTintAmount", progress);
        this.transform.localScale = this.transform.localScale * 0.995f;
        destructDuration += Time.deltaTime;
    }

    private void Rotate()
    {
        transform.Rotate(0, 0, rotationSpeed * Time.deltaTime);
    }

    private void OnMouseDown()
    {
        if (destruct) return;
        ScoreBoard.IncreaseScore(scoreIncrease);
        destruct = true;
        if (Globals.UseEffects)
        {
            Invoke("ExplosionCreate", destructTime);
        }
        else
        {
            StartCoroutine(Shrink());
        }
    }

    private void ExplosionCreate()
    {
        GameObject explosionObject = GameObject.Instantiate(explosion);
        explosionObject.transform.position = this.transform.position;
        Destroy(this.gameObject, 0.1f);
    }

    private IEnumerator Shrink()
    {
        Vector3 shrinkSize = new Vector3(0.015f, 0.015f, 0);
        transform.localScale -= shrinkSize;
        yield return new WaitForSeconds(shrinkingTime);
        StartCoroutine(Shrink());
        if (transform.localScale.x < finalScale.x && transform.localScale.y < finalScale.y) Destroy(gameObject);
    }
}