using UnityEngine;
using TMPro;
using Email.Text.RegularExpressions;
using UnityEngine.UI;

public class Keyboard : MonoBehaviour
{
    [SerializeField] private TMP_Text emailText;
    [SerializeField] private Button sendButton;
    [SerializeField] private Button continueButton;
    [SerializeField] private Toggle acceptRulesToggle;
    [SerializeField] private CanvasGroup acceptRulesGroup;
    [SerializeField] private GameObject gameCore;
    private string email = "E-mail";

    private void Start()
    {
        emailText.text = email;
        emailText.fontSize = 45;
    }

    private void Update()
    {
        SendButtonControl();
    }

    private void SendButtonControl()
    {
        if (TestEmail.IsEmail(email) && acceptRulesToggle.isOn)
        {
            acceptRulesGroup.alpha = 1.0f;
            sendButton.interactable = true;
            continueButton.interactable = true;
            return;
        }

        acceptRulesGroup.alpha = 0.3f;
        sendButton.interactable = false;
        continueButton.interactable = false;
    }


    public void WriteKey(string key)
    {
        if (email.Length > 44) return;
        
        if (email == "E-mail") email = null;

        email += key;
        emailText.fontSize = 35;
        emailText.text = email;
    }

    public void Backspace()
    {
        if (email.Length == 0 || email == "E-mail") return;

        email = email.Substring(0, email.Length - 1);
        emailText.text = email;

        if (email.Length == 0)
        {
            email = "E-mail";
            emailText.fontSize = 45;
            emailText.text = email;
        }
    }
}