using UnityEngine;

[CreateAssetMenu(menuName = "ScriptableObject/Settings")]
public class Settings : ScriptableObject
{
    [SerializeField] private float scaleMin = 0.3f;
    [SerializeField] private float scaleMax = 0.55f;
    [SerializeField] private float speedMin = 3f;
    [SerializeField] private float speedMax = 6.5f;
    [SerializeField] private float rotationSpeedMin = 100f;
    [SerializeField] private float rotationSpeedMax = 250f;

    public float ScaleMin { get { return scaleMin; } }
    public float ScaleMax { get { return scaleMax; } }
    public float SpeedMin { get { return speedMin; } }
    public float SpeedMax { get { return speedMax; } }
    public float RotationSpeedMin { get { return rotationSpeedMin; } }
    public float RotationSpeedMax { get { return rotationSpeedMax; } }
}
