using UnityEngine;
using TMPro;

public class Timer : MonoBehaviour
{
    [SerializeField] private TMP_Text timerText;
    [SerializeField] private GameObject gameScreen;
    [SerializeField] private GameObject rulesScreen;
    [SerializeField] private GameObject thankYouScreen;
    [SerializeField] private GameObject characters;
    [SerializeField] private float time = 5f;
    [SerializeField] private float gameOverTime = 8f;
    [SerializeField] private float signUpScreenTime = 60f;
    [SerializeField] private float rulesScreenTime = 60f;
    [SerializeField] private float thankYouTime = 8f;
    [SerializeField] private float withoutClickTime = 10f;
    [SerializeField] private bool disableTimers = false;
    private GameObject gameCore;
    private ScreenController screenController;
    private CharacterSpawner characterSpawner;
    private bool gameOver = false;
    public float GetTime { get { return time; } }

    public void SetSignUpScreenTime(float time)
    {
        signUpScreenTime = time;
    }

    private void Start()
    {
        timerText.text = time.ToString() + "s";
        gameCore = this.gameObject;
        screenController = gameCore.GetComponent<ScreenController>();
        characterSpawner = characters.GetComponent<CharacterSpawner>();
    }

    private void Update()
    {
        if (disableTimers) return;
        SubtractTime();
        StartGameOverTimer();
        StartSignUpScreenTimer();
        ClickControl();
    }

    private void SubtractTime()
    {
        if (!gameScreen.activeInHierarchy) return;

        if (time > 0)
        {
            if (!characterSpawner.AreStartCharactersSpawned) characterSpawner.StartGame();
            time -= Time.deltaTime;
            int timeLeft = (int)time + 1;
            timerText.text = timeLeft.ToString() + "s";
            gameOver = false;
        }
        else
        {
            if(!gameOver)
                HandleEnd();
        }
    }

    private void HandleEnd()
    {
        timerText.text = "0s";
        screenController.HandleGameOver();
        gameOver = true;
    }

    private void StartGameOverTimer()
    {
        if (time > 0 || screenController.SignUpScreenIsActive) return;

        if (gameOverTime > 0)
        {
            gameOverTime -= Time.deltaTime;
        }
        else
        {
            screenController.ReloadGame();
        }
    }

    private void StartSignUpScreenTimer()
    {
        if (time > 0 || !screenController.SignUpScreenIsActive) return;

        if (rulesScreen.activeInHierarchy)
        {
            StartRulesTimer();
            return;
        }

        if (thankYouScreen.activeInHierarchy)
        {
            StartThankYouScreenTimer();
            return;
        }

        if (signUpScreenTime > 0)
        {
            signUpScreenTime -= Time.deltaTime;
        }
        else
        {
            screenController.ReloadGame();
        }
    }

    private void StartRulesTimer()
    {
        if (rulesScreenTime > 0)
        {
            rulesScreenTime -= Time.deltaTime;
        }
        else
        {
            screenController.ReloadGame();
        }
    }

    private void StartThankYouScreenTimer()
    {
        if (thankYouTime > 0)
        {
            thankYouTime -= Time.deltaTime;
        }
        else
        {
            screenController.ReloadGame();
        }
    }

    private void ClickControl()
    {
        if (!gameScreen.activeInHierarchy || time < 0) return;

        if (Input.GetMouseButtonDown(0))
        {
            withoutClickTime = 10f;
            return;
        }

        if (withoutClickTime > 0)
        {
            withoutClickTime -= Time.deltaTime;
        }
        else
        {
            screenController.ReloadGame();
        }
    }
}