import cv2
import cv2.typing
import typing


# Classes
class DnnSuperResImpl:
    # Functions
    @classmethod
    def create(cls) -> DnnSuperResImpl: ...

    def readModel(self, path: str) -> None: ...

    def setModel(self, algo: str, scale: int) -> None: ...

    def setPreferableBackend(self, backendId: int) -> None: ...

    def setPreferableTarget(self, targetId: int) -> None: ...

    @typing.overload
    def upsample(self, img: cv2.typing.MatLike, result: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @typing.overload
    def upsample(self, img: cv2.UMat, result: cv2.UMat | None = ...) -> cv2.UMat: ...

    @typing.overload
    def upsampleMultioutput(self, img: cv2.typing.MatLike, imgs_new: typing.Sequence[cv2.typing.MatLike], scale_factors: typing.Sequence[int], node_names: typing.Sequence[str]) -> None: ...
    @typing.overload
    def upsampleMultioutput(self, img: cv2.UMat, imgs_new: typing.Sequence[cv2.typing.MatLike], scale_factors: typing.Sequence[int], node_names: typing.Sequence[str]) -> None: ...

    def getScale(self) -> int: ...

    def getAlgorithm(self) -> str: ...



