import cv2
import cv2.typing
import typing


# Classes
class Feature:
    x: int
    y: int
    label: int

    # Functions
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, label: int) -> None: ...


class Template:
    @property
    def width(self) -> int: ...
    @property
    def height(self) -> int: ...
    @property
    def pyramid_level(self) -> int: ...
    @property
    def features(self) -> typing.Sequence[Feature]: ...

class QuantizedPyramid:
    # Functions
    def quantize(self, dst: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...

    def extractTemplate(self) -> tuple[bool, Template]: ...

    def pyrDown(self) -> None: ...


class Modality:
    # Functions
    def process(self, src: cv2.typing.MatLike, mask: cv2.typing.MatLike | None = ...) -> QuantizedPyramid: ...

    def name(self) -> str: ...

    def read(self, fn: cv2.FileNode) -> None: ...

    @classmethod
    @typing.overload
    def create(cls, modality_type: str) -> Modality: ...
    @classmethod
    @typing.overload
    def create(cls, fn: cv2.FileNode) -> Modality: ...


class Match:
    x: int
    y: int
    similarity: float
    class_id: str
    template_id: int

    # Functions
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, similarity: float, class_id: str, template_id: int) -> None: ...


class Detector:
    # Functions
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, modalities: typing.Sequence[Modality], T_pyramid: typing.Sequence[int]) -> None: ...

    @typing.overload
    def match(self, sources: typing.Sequence[cv2.typing.MatLike], threshold: float, class_ids: typing.Sequence[str] = ..., quantized_images: typing.Sequence[cv2.typing.MatLike] | None = ..., masks: typing.Sequence[cv2.typing.MatLike] | None = ...) -> tuple[typing.Sequence[Match], typing.Sequence[cv2.typing.MatLike]]: ...
    @typing.overload
    def match(self, sources: typing.Sequence[cv2.typing.MatLike], threshold: float, class_ids: typing.Sequence[str] = ..., quantized_images: typing.Sequence[cv2.UMat] | None = ..., masks: typing.Sequence[cv2.typing.MatLike] | None = ...) -> tuple[typing.Sequence[Match], typing.Sequence[cv2.UMat]]: ...

    def addTemplate(self, sources: typing.Sequence[cv2.typing.MatLike], class_id: str, object_mask: cv2.typing.MatLike) -> tuple[int, cv2.typing.Rect]: ...

    def addSyntheticTemplate(self, templates: typing.Sequence[Template], class_id: str) -> int: ...

    def getModalities(self) -> typing.Sequence[Modality]: ...

    def getT(self, pyramid_level: int) -> int: ...

    def pyramidLevels(self) -> int: ...

    def getTemplates(self, class_id: str, template_id: int) -> typing.Sequence[Template]: ...

    @typing.overload
    def numTemplates(self) -> int: ...
    @typing.overload
    def numTemplates(self, class_id: str) -> int: ...

    def numClasses(self) -> int: ...

    def classIds(self) -> typing.Sequence[str]: ...

    def read(self, fn: cv2.FileNode) -> None: ...

    def readClasses(self, class_ids: typing.Sequence[str], format: str = ...) -> None: ...

    def writeClasses(self, format: str = ...) -> None: ...


class ColorGradient(Modality):
    @property
    def weak_threshold(self) -> float: ...
    @property
    def num_features(self) -> int: ...
    @property
    def strong_threshold(self) -> float: ...

    # Functions
    @classmethod
    def create(cls, weak_threshold: float, num_features: int, strong_threshold: float) -> ColorGradient: ...


class DepthNormal(Modality):
    @property
    def distance_threshold(self) -> int: ...
    @property
    def difference_threshold(self) -> int: ...
    @property
    def num_features(self) -> int: ...
    @property
    def extract_threshold(self) -> int: ...

    # Functions
    @classmethod
    def create(cls, distance_threshold: int, difference_threshold: int, num_features: int, extract_threshold: int) -> DepthNormal: ...



# Functions
def colormap(quantized: cv2.typing.MatLike, dst: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...

@typing.overload
def drawFeatures(img: cv2.typing.MatLike, templates: typing.Sequence[Template], tl: cv2.typing.Point2i, size: int = ...) -> cv2.typing.MatLike: ...
@typing.overload
def drawFeatures(img: cv2.UMat, templates: typing.Sequence[Template], tl: cv2.typing.Point2i, size: int = ...) -> cv2.UMat: ...

def getDefaultLINE() -> Detector: ...

def getDefaultLINEMOD() -> Detector: ...


